/*
** RIFF/WAV treating interfaces
**
** Writen by Sakae Tatibana <tatibana@extra.hu>
**
** 2000, 3/5 coding start
*/

#ifndef RIFF_WAV_H
#define RIFF_WAV_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef  __cplusplus
extern "C" {
#endif

typedef struct {
	char *path;
	FILE *stream;

    int   file_length;     /* bytes       */	
	int   data_length;     /* bytes       */
	int   byte_per_sec;    /* bytes/sec   */
	
	short channel;       
	int   sample_rate;     /* Hz          */
	short block_align;     /* ?           */
	short bits_per_sample; /* bits/sample */
} WAV_INFO;

#ifndef RIFF_WAV_C
extern int open_wav_file(char *in, WAV_INFO *out);
extern int close_wav_file(WAV_INFO *wi);
extern int read_wav_info(FILE *in, WAV_INFO *out);
#endif

#ifdef  __cplusplus
}
#endif

#endif